/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: WatchdogDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 4.07.06 16:23 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Watchdog trigger dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file WatchdogDlg.h
///   Watchdog trigger dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include <stdint.h>


///////////////////////////////////////////////////////////////////////////////////////////
/// Watchdog trigger dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CWatchdogDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CWatchdogDlg)

public:
	CWatchdogDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CWatchdogDlg();

// Dialog Data
	enum { IDD = IDD_WATCHDOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t  m_ulLastTriggerValue;   //!< Last returned Watchdogvalue
  bool      m_fTriggerWatchdog;     //!< true if watchdog trigger is running

	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
  afx_msg void OnBnClickedBtnStartstop();
  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

  afx_msg void OnEnKillfocusEdtTriggerinterval();
};
